import sqlite3
from prettytable import PrettyTable


def open_basiccrud_db():
    conn = sqlite3.connect('basic_crud.db')
    cursor = conn.cursor()
    return conn,cursor

def close_database(cursor, conn):
    cursor.close()
    conn.close()


def print_users_prettytable(sql):
    conn, cursor = open_basiccrud_db()
    cursor.execute(sql)
    data = cursor.fetchall()
    table = PrettyTable(['name', 'age', 'dateofbirth', 'sex', 'email'])
    for (name, age, dob, sex, email) in data:
        table.add_row([name, age, dob, sex, email])
    print(table)
    cursor.close()
    conn.close()

def open_csvtest_db():
    conn = sqlite3.connect('csvtest.db')
    cursor = conn.cursor()
    return conn,cursor

def print_titanic_prettytable(sql):
    conn, cursor = open_csvtest_db()
    cursor.execute(sql)
    data = cursor.fetchall()
    table = PrettyTable([
        'PassengerId', 'Survived', 'Pclass',
        'Name', 'Sex', 'Age', 'SibSp', 'Parch',
        'Ticket', 'Fare', 'Cabin', 'Embarked'
    ])
    for (id, survived, plass, name, sex, age, sibsp, parch, ticket, fare, cabin, embark) in data:
        table.add_row([id, survived, plass, name, sex, age, sibsp, parch, ticket, fare, cabin, embark])
    print(table)
    cursor.close()
    conn.close()
