import csv
import sqlite3

dbpath = 'csvtest.db'
conn = sqlite3.connect(dbpath)
cursor = conn.cursor()
sql = '''
CREATE TABLE IF NOT EXISTS titanic(
    PassengerId INTEGER,Survived INTEGER,
    Pclass INTEGER,Name TEXT,Sex TEXT,Age REAL,
    SibSp INTEGER,Parch INTEGER,Ticket TEXT,
    Fare REAL,Cabin TEXT,Embarked TEXT)
'''
cursor.execute(sql)
conn.commit()

# csvファイルを開きリスト変数dataに読み込み
with open('titanic.csv', 'r') as f:
    rows = csv.reader(f)
    header = next(rows)  # next関数でヘッダーを取り出し
    data = []
    for row in rows:
        data.append(row)

# executemany()で複数のINSERTを実行する
sql = '''
    INSERT INTO titanic
    (PassengerId,Survived,Pclass,Name,Sex,Age,
    SibSp,Parch,Ticket,Fare,Cabin,Embarked) 
    VALUES(?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)
'''
cursor.executemany(sql, data)
conn.commit()
cursor.close()
conn.close()