import sqlite3
from prettytable import PrettyTable


def open_basiccrud_db():
    conn = sqlite3.connect('basic_crud.db')
    cursor = conn.cursor()
    return conn,cursor

def close_database(cursor, conn):
    cursor.close()
    conn.close()


def print_users_prettytable(sql):
    conn, cursor = open_basiccrud_db()
    cursor.execute(sql)
    data = cursor.fetchall()
    table = PrettyTable(['name', 'age', 'dateofbirth', 'sex', 'email'])
    for (name, age, dob, sex, email) in data:
        table.add_row([name, age, dob, sex, email])
    print(table)
    cursor.close()
    conn.close()

